create or replace package body tbicds.PCK_USER_ADMIN is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
   /*
   get a record set of users back that match criteria
   */
   procedure GetUserLookupRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            pi_vDMISID          in varchar2,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2,
                            rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';  
   
      --open recordset
      v_vSql := 'SELECT distinct * '
                || 'FROM tbicds.app_user s '
                || 'WHERE DIMS_ID = :P0 '
                || 'ORDER BY upper(NAME) asc, ENTRY_DATE desc ';
      open rs for v_vSql using pi_vDMISID;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_USER_ADMIN.getUserLookupRS(): ' || sqlErrm;
   end;

   /*
   get a record set of users back that match criteria
   */
   procedure GetUserLookupBySearchRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_vSearchValue     in varchar2,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
      strSQL       varchar2(300);
      strSelectSQL varchar2(300);
      v_bHQRights     boolean;
      v_bMAJCOMRights boolean;
      v_vDMISID       varchar(50);
      v_nMAJCOMID     number;
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'select dims_id from tbicds.app_user where fx_user_id = :P0';
      execute immediate v_vSql into v_vDMISID using pi_nUserID;
      
      v_vSql := 'select majcom_id from tbicds.stat_dims_base where dims_id = :P0';
      execute immediate v_vSql into v_nMAJCOMID using v_vDMISID;
      
      --open recordset
      v_vSql := 'select * from tbicds.app_user s '
                || 'where UPPER(s.name) like :P0 '
                || 'order by s.dims_id, upper(s.name) asc, s.entry_date desc';
      open rs for v_vSql using UPPER('%'||pi_vSearchValue||'%');
      return;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_USER_ADMIN.getUserLookupBySearchRS(): ' || sqlErrm;
   end;

   /*
   Get user recordset
   */
   procedure GetSuatUserRS(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_vProviderID      in varchar2,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
      v_vDMISID varchar(50);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'select dims_id from tbicds.app_user where provider_id = :P0';
      execute immediate v_vSql into v_vDMISID using pi_vProviderID;
      
      --open recordset
      v_vSql := 'select user_type, name, rank, military_service_id, title, '
                || 'unit, corps, squadron, phone, email, '
                || 'dims_id, r.user_rights, locked '
                || 'from tbicds.app_user t, tbicds.fx_user_rights r '
                || 'where provider_id = :P0 '
                || 'and r.fx_user_id = t.fx_user_id '
                || 'and dims_id = :P1 ';
      open rs for v_vSql using pi_vProviderID, v_vDMISID;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_USER_ADMIN.GetSuatUserRS(): ' || sqlErrm;
   end;

   /*
   Get user name recordset
   */
   procedure GetSuatUserNameRS(pi_vSessionID       in varchar2,
                        pi_vSessionClientIP in varchar2,
                        pi_nUserID          in number,
                        pi_nFXUserID        in number,
                        po_nStatusCode      out number,
                        po_vStatusComment   out varchar2,
                        rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
      v_vDMISID varchar(50);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select user_type, name, rank, military_service_id, title, '
                || 'unit, corps, squadron, phone, email, '
                || 'dims_id, r.user_rights, locked, t.graph_pref '
                || 'from tbicds.app_user t, tbicds.fx_user_rights r '
                || 'where t.fx_user_id = :P0 '
                || 'and r.fx_user_id = t.fx_user_id ';
      open rs for v_vSql using pi_nFXUserID;
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_USER_ADMIN.GetSuatUserNameRS(): ' || sqlErrm;
   end;

   /*
   Get facility information recordset
   */
   procedure GetFacilityInfoRS(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2,
                           rs                  out RetRefCursor) is
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      open rs for
         'select * from tbicds.site t';
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_USER_ADMIN.GetFacilityInfoRS(): ' || sqlErrm;
   end;

   /*
   Insert a facility
   */
   procedure InsertFacilityInfo(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            pi_vSiteID          in varchar2,
                            pi_vSiteName        in varchar2,
                            pi_vSiteAddress1    in varchar2,
                            pi_vSiteCity        in varchar2,
                            pi_vSiteState       in varchar2,
                            pi_vSitePostalCode  in varchar2,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'insert into tbicds.site ('
                || 'site_id, site_name, site_address_1, site_city, site_state, site_postal_code) '
                || 'values (:P0, :P1, :P2, :P3, :P4, :P5) ';
      execute immediate v_vSql using
         pi_vSiteID, pi_vSiteName, pi_vSiteAddress1, pi_vSiteCity, pi_vSiteState, pi_vSitePostalCode;
      commit;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_User_Admin.InserFacilityInfo(): ' || sqlErrm;
   end;

   /*
   Update a facility
   */
   procedure UpdateFacilityInfo(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            pi_vSiteID          in varchar2,
                            pi_vSiteName        in varchar2,
                            pi_vSiteAddress1    in varchar2,
                            pi_vSiteCity        in varchar2,
                            pi_vSiteState       in varchar2,
                            pi_vSitePostalCode  in varchar2,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'update tbicds.site set '
                || 'site_id = :P0, '
                || 'site_name = :P1, '
                || 'site_address_1 = :P2, '
                || 'site_city = :P3, '
                || 'site_state = :P4, '
                || 'site_postal_code = :P5 ';
      execute immediate v_vSql using
         pi_vSiteID, pi_vSiteName, pi_vSiteAddress1, pi_vSiteCity, pi_vSiteState, pi_vSitePostalCode; 
      commit;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_USER_ADMIN.UpdateFacilityInfo(): ' || sqlErrm;
   end;

   /*
   Update graph preference
   */
   procedure UpdateGraphPref(pi_vSessionID       in varchar2,
                         pi_vSessionClientIP in varchar2,
                         pi_nUserID          in number,
                         pi_nGraphOpt        in varchar2,
                         po_nStatusCode      out number,
                         po_vStatusComment   out varchar2)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'update tbicds.app_user t set t.graph_pref = :P0 where t.fx_user_id = :P1 ';
      execute immediate v_vSql using pi_nGraphOpt, pi_nUserID; 
      commit;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_USER_ADMIN.UpdateGraphPref(): ' || sqlErrm;
   end;

   /*
   Get graph preference
   */
   procedure GetGraphPref(pi_vSessionID       in varchar2,
                      pi_vSessionClientIP in varchar2,
                      pi_nUserID          in number,
                      po_nStatusCode      out number,
                      po_vStatusComment   out varchar2,
                      rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'select * from tbicds.app_user t where t.fx_user_id = :P0';
      open rs for v_vSql using pi_nUserID;
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_USER_ADMIN.GetGraphPref(): ' || sqlErrm;
   end;

end;
/

